#include <stdio.h> /* Standard Input/ Output Library */
#include <stdlib.h>
#include <math.h>
#include "matrix_solver.h"

#define NBIN 5000

//differs from v2 in that reads in and writes out errors

//differs from v1 in that work out gaussian integration once
//at the beginning in terms of sigma, store in an array and
//then use this to calculate phi


#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))

/* Global variables */
double sigma=1.5/2.354; //fwhm/2.354
double pitch=2.034;

int getgauss(double *gaussval, double _step)
{
  double *gaussval_ptr, term1, term2, term3, pos;

  pos=-5*sigma;
  for(gaussval_ptr=&gaussval[0];gaussval_ptr<&gaussval[NBIN];gaussval_ptr++){
    term1 = 1.0 / (sqrt(2.0*M_PI) * sigma);
    term2 = (0 - pos)/ sigma;
    term3 = -0.5 * pow(term2, 2);
    
    *gaussval_ptr=term1 * pow(M_E, term3);
    pos+=_step;
  }
  return 0;
}

double gaussint(double *gaussval, double _ilow, double _ihi, double _peakpos, double _step)
{

  double tot, fivsig, nlowbin, nhibin;
  int i;

  tot=0.0;
  fivsig=5*sigma;

  _ilow=_ilow-_peakpos;
  _ihi=_ihi-_peakpos;

  nlowbin=floor(((_ilow+fivsig)/_step)+0.5);
  nhibin=floor(((_ihi+fivsig)/_step)+0.5);

  for(i=nlowbin;i<nhibin;i++)
    tot+=gaussval[i]*_step;
  
  return tot;
}

int getval1 (char *filename, double *val, int ppsize)
{
  /*read in doubles from file filename */
  /*CHANGE to read from IRAF database file*/

  int i, numval;
  FILE *infile;

  if ((infile=fopen(filename,"r")) == NULL){
    fprintf(stderr,"Cannot open %s\n", filename);
    exit(-1);
  }

  i=0;
  do {
    fscanf(infile,"%lf",val+i);
    i++;
  } while(!feof(infile)&&i<=ppsize);
  numval=i-1;

  return numval;
}

int getphi ( double *peakpos, int numpk, int numval, int type, double **phi)
{

  double pmin, pmax, ilow, ihi, step;
  double gaussval[NBIN];
  int i,j,pixnum;

  printf("in getphi\n");
  printf("sigma %g NBIN %d\n",sigma,NBIN);

  step=(10*sigma)/NBIN;
  printf("step is %g\n",step);

  //populate gaussian array values
  getgauss(gaussval,step);

  for(j=0;j<numpk;j++){
    if((type==1)||(type==2)){
      pmin=peakpos[j]-5*sigma;
      pmax=peakpos[j]+5*sigma;
      //printf("type = %d j %d pmin %g pmax %g peak %g\n",type,j,pmin,pmax,peakpos[j]);
    }
    else{
      if((j==0)||(j==1)){
	pmin=peakpos[j]-2*pitch;
      //printf("%s %d %s %g\n","j",j,"peakpos",peakpos[j]);
      }
      else{
	pmin=peakpos[j-2];
      }
      if((j==numpk-1)||(j==numpk-2)){
	pmax=peakpos[j]+2*pitch;
      }
      else{
	pmax=peakpos[j+2];
      }
      //printf("type not 1 j %d pmin %g pmax %g peak %g\n",j,pmin,pmax,peakpos[j]);
    }

    for(i=0;i<numval;i++){
      //use i+1 here because these are pixel centres and first pixel is centred at 1
      pixnum=i+1;


      if((pixnum<abs(pmin+0.5))||(pixnum>abs(pmax+0.5))){
	phi[j][i]=0.0;
      }
      else{
	ilow=MAX(pixnum-0.5,pmin);
	ihi=MIN(pixnum+0.5,pmax);

	//	printf("%s %d\n","setphi for",i);
	  
	phi[j][i]=gaussint(gaussval,ilow,ihi,peakpos[j],step);
	//	printf("j %d pixel number %d integrate from ilow %g to ihi %g phi[j][i] %g\n",j,pixnum,ilow,ihi,phi[j][i]);

      }
    }
  }

  return 0;
}

int getdiag(double **phi, double *pixvar, double *b, double *c, double *d, double **A, int numpk, int numval, int type)
{
  int i,k;
  double temp;
  //get diagonals of tridiagonal and 5-band diagonal matrix
  
  printf("in getdiag numpk %d numval %d\n",numpk,numval);
  for(k=0;k<numpk;k++){
    if((type!=1)&&(k>1)){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k-2][i]>0)){
	  temp=phi[k][i]*phi[k-2][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][0]+=temp;
      }
    }
    if(k>0){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k-1][i]>0)){
	  temp=phi[k][i]*phi[k-1][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][1]+=temp;
      }
    }
    //printf("after a i is %d\n",i);
    for(i=0;i<numval;i++){
      if(phi[k][i]>0){
	temp=phi[k][i]*phi[k][i]/pixvar[i];
      }
      else{
	temp=0;
      }
      A[k][2]+=temp;
    }
    if(k<(numpk-1)){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k+1][i]>0)){
	  temp=phi[k][i]*phi[k+1][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][3]+=temp;
	//if((phi[k][i]>0)&&(phi[k+1][i]>0))
	//printf("%s %d %s %d %s %g %s %g %s %g\n","k",k,"i",i,"phi[k][i]",phi[k][i],"phi[k+1][i]",phi[k+1][i],"c",c[k]);
      }
    }
    if((type!=1)&&(k<numpk-2)){
      for(i=0;i<numval;i++){
	if((phi[k][i]>0)&&(phi[k+2][i]>0)){
	  temp=phi[k][i]*phi[k+2][i]/pixvar[i];
	}
	else{
	  temp=0;
	}
	A[k][4]+=temp;
      }
    }
    //printf("k %d a %g b %g c %g d %g e %g \n",k,a[k],b[k],c[k],d[k],e[k]);
  }
  
  for(i=0;i<499;i++){
    b[i]=A[i][1];
    c[i]=A[i][2];
    d[i]=A[i][3];
  }

return 0;
}

int getr(double *pixval, double *pixvar, double **phi, double numpk, double numval, double *r)
{
  int i,j;

  for(j=0;j<numpk;j++){
    for(i=0;i<numval;i++){
      r[j]+=pixval[i]*phi[j][i]/pixvar[i];
      //if(phi[j][i]>0)
      //printf("%s %d %s %d %s %g %s %g %s %g\n","j",j,"i",i,"phi[j][i]",phi[j][i],"pixval[i]",pixval[i],"r[j]",r[j]);
    }
  }

  return 0;
}

int getoutvar(double *pixvar, double **phi, double numpk, double numval, double *outvar)
{
  int i,j;

  //output variance for each profile is the value of the variance in a pixel 
  //multiplied by the value of the profile in that pixel. this seems like
  //a fairly sensible way of doing things ?
  for(j=0;j<numpk;j++){
    for(i=0;i<numval;i++){
      //      printf("%g\n",pixvar[i]);
      outvar[j]+=pixvar[i]*phi[j][i];
    }
  }

  return 0;
}

int main ()
{
  int numpk, numval;
  double scale;
  double dd[1];
  int indx[499];
  double peakpos[499];
  double pixval[2048];
  double pixvar[2048];
  double *phi[499];
  double *A[499];
  double *al[499];
  double b[499];
  double c[499];
  double d[499];
  double r[499];
  double u[499];
  double outvar[499];
  char filename[255];
  int i, j, type;
  
  printf("sigma is %g\n",sigma);
  printf("nbin is %d\n",NBIN);

  for(i=0;i<499;i++){
    phi[i]=(double*)malloc(2048*sizeof(double));
    A[i]=(double*)malloc(5*sizeof(double));
    al[i]=(double*)malloc(2*sizeof(double));
  }

  //read coordinates of peaks from file
  sprintf(filename,"peakpos.list");
  numpk = getval1(filename, peakpos, 499);
  printf("%s %d\n","numpk",numpk);

  scale=pitch/sigma;
  printf("pitch of %g = %g * sigma of %g\n",pitch,scale,sigma);
  //for(i=0;i<numpk;i++) printf("%s %d %s %g\n","i",i,"peakpos",peakpos[i]);
  //3 possibilities - 5sigma <= pitch, 2*pitch >= 5sigma > pitch, 2pitch < 5sigma 
  if(scale >= 5) type=1;
  if((scale < 5) && (scale >= 2.5)) type=2;
  if(scale < 2.5) type =3;
  printf("type %d\n",type);
  if(type==3){
    printf("Warning: this program assumes each spectrum only overlaps the four closest neighbouring spectra. With these values of pitch and fwhm this means that < 5sigma of the profile is integrated over, which will lead to errors in the sum\n");
  }

  //read pixel values from filename input by user
  printf("input filename containing (2048) data values\n");
  scanf("%s",filename);

  numval = getval1(filename, pixval, 2048);
  //printf("%s %d\n","numval",numval);

  //  for(i=0;i<numval;i++) printf("%s %d %g\n","pixval",i,pixval[i]);

  //read error values from filename input by user


  getphi(peakpos, numpk, numval, type, phi);
  printf("input filename containing (2048) variance values\n");
  scanf("%s",filename);

  numval = getval1(filename, pixvar, 2048);
  //printf("%s %d\n","numval",numval);

  //for(i=0;i<numval;i++) printf("%s %d %g\n","pixvar",i,pixvar[i]);

  //printf("%s\n","in main phi");
  //for(i=0;i<numpk;i++){
  //for(j=0;j<numval;j++){
  //if(phi[i][j]>0.0)
  //printf("i %d j %d phi[i][j] %g\n",i,j,phi[i][j]);
  //}
  //}

  getdiag(phi,pixvar,b,c,d,A,numpk,numval,type);
  printf("after getdiag\n");

  getr(pixval,pixvar,phi,numpk,numval,r);
  printf("after getr\n");

  //get output variance
  getoutvar(pixvar,phi,numpk,numval,outvar);
  printf("after getoutvar\n");

  //for(i=0;i<numpk;i+=1){
  //if(r[i]>0)
  //  printf("i %d a %g b %g c %g r %g\n",i,a[i],b[i],c[i],r[i]);
  //}
  //for(i=0;i<numpk;i++) printf("r %g\n",r[i]);

  if(type==1){
    tridiag(b,c,d,r,u,numpk);
  }
  else{
    bandec(A,numpk,2,2,al,indx,dd);
    banbks(A,numpk,2,2,al,indx,r);
  }
  if(type==1){
    for(i=0;i<numpk;i++) printf("ap %d sum %g variance %g\n",i,u[i],outvar[i]);
  }
  else{
    for(i=0;i<numpk;i++) printf("ap %d sum %g variance %g\n",i+1,r[i],outvar[i]);
  }
  return 0;
}

